/*******************************************************************
/*  bbe_def.h
/*  Author: Vadim Berman
/*
/*  Description:
/*  this file includes all the defines & macros and most typedef's
/*
/*  The contents of this file are subject to the Brainiac Public License.
/*  Version 1.0 (the "License"); you may not use this file except in
/*  compliance with the License. You may obtain a copy of the License at
/*  http://www.twilightminds.com
/*
/*  Software distributed under the License is distributed on an "AS IS"
/*  basis WITHOUT WARRANTY OF ANY KIND, either express or implied. See
/*  the License for the specific language governing rights and limitations
/*  under the License.
/*
/*  Copyright (C) 1999 Twilight Minds. All rights reserved.
/********************************************************************/
#define BBECALL __stdcall

#ifdef COMPILER_VISUALC
#pragma warning (disable: 4244)
#define EXPO _declspec(dllexport)
#endif

#ifdef __BORLANDC__
#define EXPO  __declspec(dllexport) //_export
#endif

typedef signed char percentage; //basic attribute type
//we need SIGNed byte here because many values, like Wickedness or
//Anarchy, can be negative. Generally, it will be used in range -100..100
#define EXTREME_PER_VAL 100
//--------------- percentage validation macro -----------------------------
#define VALID_PERCENTAGE(x) (percentage)((x) < -EXTREME_PER_VAL ? \
    -EXTREME_PER_VAL : ( (x) > EXTREME_PER_VAL ? EXTREME_PER_VAL : (x)))
//--------------- other auxiliary defines ---------------------------------
#define ABS(x) ( (x)<0 ? (-(x)) : (x) )
#define ERROR_PERCENTAGE  -127
#define ERROR_UBYTE  129
#define SWAP(a,b,t) (t) = (a); (a) = (b); (b) = (t);
#define APPROX(a,b)( (ABS((a)-(b)) < ((a)+(b))/(WORTHY_PART*2)) ? 0 : 1)

typedef unsigned char abs_percentage; //rarely used unsigned percentage counterpart
typedef unsigned short ID; //basic Brainiac ID type - 2 byte integer
//---------------------------------------------------------------------------------
typedef unsigned char ActionError;

#define UNSURPASSED_MORAL_DIFF 50
#define END_STR_ON_SUCCESS     0xFF

#define SAME_ACTION         0

#define MANUAL_GOAL        0xFF
#define SEEMED             0
#define BOTH               2

//--------------- Criterion comparison types --------------------------------------
#define COMP_ABS            0
#define COMP_REL2EVAL       1
#define COMP_REL2SOBJ       2
#define COMP_REL2LINI       3
#define COMP_ABS_EVAL       4
//--------------- Criterion reference action types --------------------------------
#define FL1_LASTINIT        1
#define FL1_LASTOBJ         2
//--------------- Criterion attitude comparison types -----------------------------
#define CRIT_ATT2EVAL         1
#define CRIT_ATT_BY_EVAL      2
#define CRIT_ATT2STROBJ       3
#define CRIT_ATT_BY_STROBJ    4
#define CRIT_ATT2LASTINIT     5
#define CRIT_ATT_BY_LASTINIT  6
#define CRIT_ATT2REFACTOBJ    7
#define CRIT_ATT_BY_REFACTOBJ 8
//...and offset, for proper mapping
#define CRIT_ATT_OFFSET       3
//--------------------------------------------------------------
#define ERROR_PERCENT(Intel) ((100 - (Intel) * 8) < 0 ? 0 : (100 - (Intel) * 8))

/************** Action referencing in strategies ***********
    *******************
    * 7|6|5|4|3|2|1|0 *
    *******************
Bit 7 is 1 when the reference is to verbal action.
Bit 0 is 0 when the reference is to Reported1 and 1 when to Reported2
*/
#define GET_BASE_ACT_NUM(act_num) (((act_num) << 1) >> 2)
#define IS_REF_TO_REP(act_num)  ((act_num) & 0x80)
#define IS_REP1(act_num) (!((act_num) & 1))
//--------------------- Error handler defines --------------------------------
#define MAX_ERROR_LEN   255
#define INVALID_PARAM   -1
#define INVALID_PROP    -2
#define PERSON_DEAD     -3
#define MEM_ALLOC_FAILED -4
//--------------------- Environments ------------------------------------
#define ALL_ENV 		0
#define FRIENDLY_ENV 	1
#define NEUTRAL_ENV 	2
#define HOSTILE_ENV 	3
//--------------------- Basic Scores mapping ----------------------------
#define WICK     0
#define ANAR     1
#define INIT_ATT 2
#define ACU      3
#define SCHANGE  4
#define LIE_PROB 5
#define MEANNESS 6
#define WEALTH   7
#define BEAUTY   8
#define FOREIGN  9
#define INT      10
#define COU      11
//--------------------- Other defines -----------------------------------
#define MAX_ACTIONS 50
#define AVG_INT		9
#define LARGE_DIFF	50
#define WORTHY_PART 5

#define AVERAGE 9
#define SCORES_NUM 6
#define MAX_VERBAL_LEN 200
#define CUSTOM_MINDSET_START    10

// -- Alignment defines used to be part of enum ---
#define alPureGood      0
#define alLawfulGood    1
#define alLawfulNeutral 2
#define alLawfulEvil    3
#define alNeutralGood   4
#define alTrueNeutral   5
#define alNeutralEvil   6
#define alChaoticGood   7
#define alChaoticNeutral  8
#define alChaoticEvil   9
#define alUltimateEvil  10

#define UNSURPASSED_IMPORTANCE 11
//------------------- ActionError codes ----------------------------
#define ACTION_SUCCESS        0
#define ACTION_FAILURE        1
#define ACTION_NOT_PRIMED     2
#define NO_CANDIDATES         3
#define LO_WICK               4
#define HI_WICK               5
#define LO_ANA                6
#define HI_ANA                7
#define  LO_INT               8
#define  HI_INT               9
#define  LO_COU               10
#define TOO_FOREIGN           11
#define	NOT_INTERESTED_IN_DEAL			12
#define BAD_COMBAT_ODDS       13
#define WOULD_NOT_BELIEVE     14
#define HI_ATT                15
#define LO_ATT                16
#define NO_TRUST              17
#define PAST_FAILURE          18
#define STRATEGY_ABORTED      19

//------------ Strategy type defines ---------------------------
#define STRTYPE_REGULAR   0
#define STRTYPE_GROUP     1
//------------------------ Goals -------------------------------------------
#define GOAL_NONE				0
#define GOAL_ITEM_ACQUISITION	1
//-----------------------------------------------------------------------
//--------- Macros to ease the Objective Item ID extraction -------------
//-----------------------------------------------------------------------
#define ITEM_ITEMID(it_p) ((it_p) == NULL ? (ID)0 : (it_p)->ItemID)

#define ACTION_ITEMID(act_p) ((act_p) == NULL ? (ID)0 :\
            ((act_p)->GetObjItem() == NULL ? (ID)0 : \
            (act_p)->GetObjItem()->ItemID ) )

#define STRATEGY_ITEMID(strat) ((strat).GetObjItem() == NULL ? (ID)0 :\
            (strat).GetObjItem()->ItemID == NULL)
//-----------------------------------------------------------------------
#define SOCIAL_INFLUENCE 0.3  //used in Action
//--------------------- Record lengths / other record defines -----------
#define ITEM_CRITERIA_RECORDS_START 200
#define GOAL_REC_SIZE   160
#define ACT_REC_SIZE    120
#define MND_REC_SIZE    97

#define FUNCTION_LEN  61
#define VERB_LEN      21
#define GOAL_DESC_LEN 26
#define MIND_DESC_LEN 26
#define STR_NAME_LEN  16
#define STR_DESC_LEN  51
#define ACT_DESC_LEN  21

#define MAX_MODULE_NAME 101
#define PARAM_MODULE    1
#define MODULE_BE       0
//---------- Convert attitude to item to the importance of acquisition --
#define ATT2ITEM2WEA(x) (percentage)(( (x) > 30? ((x) - 30) : (ABS(x)))/10)
//-----------------------------------------------------------------------
//minimal significant attitude change
#define MIN_SIGNIFICANT_ATT 10
//bonus when trying to replace an old strategy with a new one
#define ALREADY_STARTED_FACTOR 1
//--------- Criterion restrictions --------------------------------------
#define ALL_BUT_SELF        0
#define NOT_STR_OBJ         1
#define NOT_LISTED_IN_STR   2
#define SELF_ONLY           4
//-----------------------------------------------------------------------
#define MIN_IMPORTANCE  2
//single action impact on the Wickedness / Anarchy
#define SINGLE_ACTION_INFLUENCE 0.2
//------------------- EventRegistry types -------------------------------
#define ACTION_PROMISE        0
#define ACTION_FAILURE        1
#define STRATEGY_FAILURE      2
#define MEMBER_SELECT_FAILURE 3 //currently unused - substituted by ACTION_FAILURE
//------------------- VerbalUnit defines ------------------------------------
#define BAD_REQUEST_MODIFY  -2
#define AGREE_FACTOR_YES_LIMIT      1.4
#define AGREE_FACTOR_ATTCHG_LIMIT   2
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//--------------- Leadership type defines -----------------------------------
//---------------------------------------------------------------------------
#define PRESENT_LEADER_ONLY  0
#define REELECTABLE_LEADER   1
#define NO_LEADER            2
#define DISMANTLE_ON_STR_END 3
//---------------------------------------------------------------------------
//--------------- Execution type defines ------------------------------------
//---------------------------------------------------------------------------
#define COORDINATE      0
#define IMMEDIATE       1
#define NO_RETURN       2
#define COMMON_EFFORT   3
//---------------------------------------------------------------------------
//--------------- Activity type defines -------------------------------------
//---------------------------------------------------------------------------
//FALSE, which is regular "false" and shouldn't be redefined
#define MEMBERS_SELECT      1
#define STRATEGY_EXECUTION  2
//---------------------------------------------------------------------------
#define ALTOGETHER      0xFFFF
//---------------------------------------------------------------------------
